package it.eng.eremita.jpa.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import io.leangen.graphql.annotations.GraphQLQuery;
import it.eng.eremita.graphql.types.Identifiable;

@Entity
@Table(name="MAIN_UTENTE")
public class Utente implements Serializable,Identifiable<String> {

	String id;
	String nome;
	String cognome;
	String email;
	
	Ruolo ruolo;
	Date ultimoLogin;
	Date scadenzaAccount;
	
	@Id
	@Column(name="ID")
	@GraphQLQuery(name="id")
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	
	@Column(name="NOME")
	@GraphQLQuery(name="nome")
	public String getNome() {
		return nome;
	}
	public void setNome(String nome) {
		this.nome = nome;
	}
	
	@Column(name="COGNOME")
	@GraphQLQuery(name="cognome")
	public String getCognome() {
		return cognome;
	}
	public void setCognome(String cognome) {
		this.cognome = cognome;
	}
	
	@Column(name="EMAIL")
	@GraphQLQuery(name="email")
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	
	@ManyToOne
	@JoinColumn(name="RUOLO")
	@GraphQLQuery(name="ruolo")
	public Ruolo getRuolo() {
		return ruolo;
	}
	public void setRuolo(Ruolo ruolo) {
		this.ruolo = ruolo;
	}
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="ULTIMO_LOGIN")
	@GraphQLQuery(name="ultimoLogin")
	public Date getUltimoLogin() {
		return ultimoLogin;
	}
	public void setUltimoLogin(Date ultimoLogin) {
		this.ultimoLogin = ultimoLogin;
	}
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="SCADENZA_ACCOUNT")
	@GraphQLQuery(name="scadenzaAccount")
	public Date getScadenzaAccount() {
		return scadenzaAccount;
	}
	public void setScadenzaAccount(Date scadenzaAccount) {
		this.scadenzaAccount = scadenzaAccount;
	}
	
	public boolean equals(Object o) {
		if (o==null) return false;
		
		if (!(o instanceof Utente)) return false;
		
		Utente ms = (Utente)o;
		if (ms.getId()==this.getId()) return true;
		if (ms.getId()==null) return false;
		return (ms.getId().equals(this.getId()));

	}
	
	@Override
	public String toString() {
		return "Utente-"+getId();
	}
	
	@Override
	public int hashCode() {
		return (getId()!=null?getId().hashCode():0 );
	}
	

}
